<?php

function GetMenuBgColor()
{
	$color=db_query("SELECT field_kolor_paska_menu_value FROM field_data_field_kolor_paska_menu LIMIT 1")->fetchField();
	return $color;
}

function GetParentTerm($tid)
{
	return db_query("SELECT parent FROM taxonomy_term_hierarchy WHERE tid = $tid")->fetchField();
}

function GetTermName($tid)
{
	return db_query("SELECT name FROM taxonomy_term_data WHERE tid = $tid")->fetchField();
}

function GetSubTerms($tid)
{
	$parentTid=GetParentTerm($tid);
	if($parentTid != 0)
		$tid=$parentTid;
		
	$res=db_query("SELECT td.tid, td.name, td.weight FROM taxonomy_term_data AS td JOIN taxonomy_term_hierarchy AS th ON td.tid=th.tid WHERE th.parent=$tid ORDER BY td.weight");	
	$arr=array();
	while($rec=$res->fetchObject())
	{
		$arr[]=array("tid"=>$rec->tid, "name"=>$rec->name);
	}
	return $arr;
}

//-- zwraca ilość produktów w grupie/kategorii -----------------------
function GetProductCountInGroup($tid)
{
	return db_query("SELECT COUNT(*) FROM field_data_field_grupa WHERE bundle='produkt' AND field_grupa_tid=$tid")->fetchField();
}
//^^ -----------------------------------------------------------------

function GetProductFromTaxonomy($tid)
{
	$parentTid=GetParentTerm($tid);
	if($parentTid != 0 || $tid==3)
		$query="SELECT fg.entity_id FROM field_data_field_grupa AS fg WHERE fg.field_grupa_tid=$tid";
	else
		$query="SELECT fg.entity_id FROM field_data_field_grupa AS fg JOIN taxonomy_term_hierarchy AS th ON fg.field_grupa_tid=th.tid WHERE th.parent=$tid";
		
	$res=db_query($query);
	$arr=array();
	while($rec=$res->fetchObject())
	{
		$arr[]=$rec->entity_id;
	}
	return $arr;
}

function GetBreadCrumb($tid)
{
	$res=db_query("SELECT tid, name FROM taxonomy_term_data WHERE tid IN ((SELECT parent FROM taxonomy_term_hierarchy WHERE tid=$tid), (SELECT tid FROM taxonomy_term_hierarchy WHERE tid=$tid))");
	$arr=array();
	while($rec=$res->fetchObject())
	{
		$arr[]=array("tid"=>$rec->tid, "name"=>$rec->name);
	}
	return $arr;
}

function GetHomePageData()
{
	$homeNode=node_load(db_query("SELECT nid FROM node WHERE type='homepage' LIMIT 1")->fetchField());
	return array("fb"=>$homeNode->field_social_links['und'][0]['value'], "pin"=>$homeNode->field_social_links['und'][1]['value'], "rights"=>$homeNode->field_copyrights['und'][0]['value']);
}

function GetGallery($gId)
{
	$galNode=node_load($gId);
	$arr=array();
	foreach($galNode->field_zdjecia['und'] as $img)
		$arr[]=$img['uri'];
	return $arr;
}

function GetMenuNameForNode($nid)
{
	$res=db_query("SELECT link_title FROM menu_links WHERE link_path = 'node/$nid' ")->fetchField();
	return $res;	
}

?>